from __future__ import print_function
from typing import Counter
from mbientlab.metawear import MetaWear, libmetawear, parse_value, create_voidp, create_voidp_int
from mbientlab.metawear.cbindings import *
from time import sleep
from threading import Event

import sys

print("Searching for device...")
metawear_mac = "E3:72:C9:68:D5:35"
d = MetaWear(metawear_mac)

d.connect()
print("Connected to " + d.address)

print("Configuring device")

counter = 0

print("Reseting metawear")

e = Event()
d.on_disconnect = lambda status: e.set()

device_info = libmetawear.mbl_mw_metawearboard_get_device_information(d.board)
print(device_info.contents.__repr__())
libmetawear.mbl_mw_logging_stop(d.board)
# Clear the logger of saved entries
libmetawear.mbl_mw_logging_clear_entries(d.board)
# Remove all macros on the flash memory
libmetawear.mbl_mw_macro_erase_all(d.board)
# Restarts the board after performing garbage collection
libmetawear.mbl_mw_debug_reset_after_gc(d.board)
print("Erase logger, state, and macros")

print("Disconnected")
libmetawear.mbl_mw_debug_reset(d.board)
sleep(2)
d.disconnect()
e.wait()


