from __future__ import print_function
from typing import Counter
from mbientlab.metawear import MetaWear, libmetawear, parse_value, create_voidp, create_voidp_int
from mbientlab.metawear.cbindings import *
from time import sleep
from threading import Event

import sys

print("Searching for device...")
metawear_mac = "E3:72:C9:68:D5:35"
d = MetaWear(metawear_mac)
d.connect()
print("Connected to " + d.address)


counter = 0
try:
    print("Configuring device")
    # setup ble
    

    libmetawear.mbl_mw_settings_set_connection_parameters(d.board, 7.5, 7.5, 0, 6000)
    sleep(1.5)
    # setup quaternion
    libmetawear.mbl_mw_sensor_fusion_set_mode(d.board, SensorFusionMode.NDOF)
    libmetawear.mbl_mw_sensor_fusion_set_acc_range(d.board, SensorFusionAccRange._8G)
    libmetawear.mbl_mw_sensor_fusion_set_gyro_range(d.board, SensorFusionGyroRange._2000DPS)
    libmetawear.mbl_mw_sensor_fusion_write_config(d.board)
    sleep(1.0)

    
    fuser_signal = libmetawear.mbl_mw_sensor_fusion_get_data_signal(d.board, SensorFusionData.QUATERNION)

    
    fuser_timed_processor = create_voidp(lambda fn: libmetawear.mbl_mw_dataprocessor_time_create(fuser_signal, TimeMode.ABSOLUTE , 125,None, fn))

    
    fuser_logger = create_voidp(lambda fn: libmetawear.mbl_mw_datasignal_log(fuser_timed_processor  , None, fn), resource = "fuser_logger")
    


     
    fuser_logger_id = libmetawear.mbl_mw_logger_generate_identifier(fuser_logger)
    print(fuser_logger_id)
    
    libmetawear.mbl_mw_sensor_fusion_enable_data(d.board, SensorFusionData.QUATERNION)
    libmetawear.mbl_mw_sensor_fusion_start(d.board)




    print("Start logging")
    libmetawear.mbl_mw_logging_start(d.board, 0)
	
except RuntimeError as err:
    print(err)
finally:
    print("Disconecting")
    
    e = Event()
    d.on_disconnect = lambda status: e.set()
    sleep(1)
    d.disconnect()
    e.wait()


    
