from __future__ import print_function
from typing import Counter
from mbientlab.metawear import MetaWear, libmetawear, parse_value, create_voidp, create_voidp_int
from mbientlab.metawear.cbindings import *
from time import sleep
from threading import Event

import sys

print("Searching for device...")
metawear_mac = "E3:72:C9:68:D5:35"
d = MetaWear(metawear_mac)
d.connect()
print("Connected to " + d.address)

print("Configuring device")

counter = 0
try:
    print("Get and log acc, gyro and mag signal")
    libmetawear.mbl_mw_acc_set_odr(d.board, 25.0)
    libmetawear.mbl_mw_acc_set_range(d.board, 8.0)
    libmetawear.mbl_mw_acc_write_acceleration_config(d.board)
    sleep(1.0) 
    acc_signal = libmetawear.mbl_mw_acc_get_acceleration_data_signal(d.board)

    acc_timed_processor = create_voidp(lambda fn: libmetawear.mbl_mw_dataprocessor_time_create(acc_signal, TimeMode.ABSOLUTE, 125,None, fn))

    acc_logger = create_voidp(lambda fn: libmetawear.mbl_mw_datasignal_log(acc_timed_processor, None, fn), resource = "acc_logger")
    sleep(1.0) 
    acc_logger_id = libmetawear.mbl_mw_logger_generate_identifier(acc_logger)
    print(acc_logger_id)
    

    libmetawear.mbl_mw_gyro_bmi160_set_range(d.board, GyroBoschRange._1000dps)
    libmetawear.mbl_mw_gyro_bmi160_set_odr(d.board, GyroBoschOdr._25Hz)
    libmetawear.mbl_mw_gyro_bmi160_write_config(d.board)
    sleep(1)

    gyro_signal = libmetawear.mbl_mw_gyro_bmi160_get_rotation_data_signal(d.board)
    gyro_timed_processor = create_voidp(lambda fn: libmetawear.mbl_mw_dataprocessor_time_create(gyro_signal, TimeMode.ABSOLUTE, 125,None, fn))
    gyro_logger = create_voidp(lambda fn: libmetawear.mbl_mw_datasignal_log(gyro_timed_processor, None, fn))
    sleep(1.0) 
    gyro_logger_id = libmetawear.mbl_mw_logger_generate_identifier(gyro_logger)
    print(gyro_logger_id)


    libmetawear.mbl_mw_mag_bmm150_set_preset(d.board, MagBmm150Preset.LOW_POWER)
    sleep(1)
    mag_signal = libmetawear.mbl_mw_mag_bmm150_get_b_field_data_signal(d.board)
    mag_timed_processor = create_voidp(lambda fn: libmetawear.mbl_mw_dataprocessor_time_create(mag_signal, TimeMode.ABSOLUTE, 125,None, fn))
    mag_logger = create_voidp(lambda fn: libmetawear.mbl_mw_datasignal_log(mag_timed_processor, None, fn))
    sleep(1.0) 
    mag_logger_id = libmetawear.mbl_mw_logger_generate_identifier(mag_logger)
    print(mag_logger_id)

    print("Sampling sensors")
    libmetawear.mbl_mw_acc_enable_acceleration_sampling(d.board)
    libmetawear.mbl_mw_gyro_bmi160_enable_rotation_sampling(d.board)
    libmetawear.mbl_mw_mag_bmm150_enable_b_field_sampling(d.board)
    sleep(1)
    print("Starting sensors")
    libmetawear.mbl_mw_acc_start(d.board)
    libmetawear.mbl_mw_gyro_bmi160_start(d.board)
    libmetawear.mbl_mw_mag_bmm150_start(d.board)
    sleep(1)



    print("Start logging")
    libmetawear.mbl_mw_logging_start(d.board, 0)
	
except RuntimeError as err:
    print(err)
finally:
    print("Disconecting")
    
    e = Event()
    d.on_disconnect = lambda status: e.set()
    sleep(1)
    d.disconnect()
    e.wait()
    print("Logging finished")

    
