package it.beonsolutions.rehabhome;

import android.app.Activity;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import com.mbientlab.bletoolbox.scanner.BleScannerFragment;
import com.mbientlab.metawear.MetaWearBoard;
import com.mbientlab.metawear.android.BtleService;
import com.mbientlab.metawear.module.Debug;
import com.mbientlab.metawear.module.Settings;

import java.util.UUID;

import bolts.Continuation;
import bolts.Task;

public class SearchSensorActivity extends Activity implements ServiceConnection, BleScannerFragment.ScannerCommunicationBus {

    /**
     * Key to read back the output
     */
    public static final String PARAM_SELECTED_DEVICE = "BT_DEVICE";

    private static final String LOG_TAG = "SENSOR";
    private BtleService.LocalBinder serviceBinder;
    private MetaWearBoard metawear;
    private BluetoothDevice btDevice;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getPackageManager().hasSystemFeature(PackageManager.FEATURE_BLUETOOTH_LE)) {
            setContentView(R.layout.activity_main);
        } else {
            setContentView(R.layout.activity_main_emu);
        }

        // Bind the mbientlab service when the activity is created
        getApplicationContext().bindService(new Intent(this, BtleService.class),
                this, Context.BIND_AUTO_CREATE);

    }

    // -------------- ServiceConnection implementation ---------------------------------
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        // Typecast the binder to the service's LocalBinder class
        serviceBinder = (BtleService.LocalBinder) service;

    }

    @Override
    public void onServiceDisconnected(ComponentName componentName) { }



    // ---------- BleScannerFragment.ScannerCommunicationBus implementation ---------------------

    @Override
    public UUID[] getFilterServiceUuids() {
        // copiato da app "starter"
        return new UUID[] {MetaWearBoard.METAWEAR_GATT_SERVICE};
    }

    @Override
    public long getScanDuration() {
        return 10000L;
    }

    /**
     * Called when the user has selected a Bluetooth device from the device list.
     * Copied from the starter mbientlab app
     *
     * @param device Device the user selected
     */
    @Override
    public void onDeviceSelected(BluetoothDevice device) {
        metawear = serviceBinder.getMetaWearBoard(device);
        btDevice = device;
        final ProgressDialog connectDialog = new ProgressDialog(this);
        connectDialog.setTitle(getString(R.string.title_connecting));
        connectDialog.setMessage(getString(R.string.message_wait));
        connectDialog.setCancelable(false);
        connectDialog.setCanceledOnTouchOutside(false);
        connectDialog.setIndeterminate(true);
        connectDialog.setButton(DialogInterface.BUTTON_NEGATIVE,
                getString(android.R.string.cancel),
                new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        metawear.disconnectAsync();
                    }
                });
        connectDialog.show();

        metawear.connectAsync().continueWithTask(task -> {
            if (task.isCancelled()) {
                Log.i(LOG_TAG, "onDeviceSelected: task was cancelled");
                return task;
            }
            Task<Void> t2;
            if (task.isFaulted()) {
                Log.e(LOG_TAG, "onDeviceSelected: task failed", task.getError());
                t2 = reconnect(metawear);
            } else {
                t2 = Task.forResult(null);
            }
            return t2;
        })
                .continueWith(task -> {
                    if (!task.isCancelled()) {
                        runOnUiThread(connectDialog::dismiss);
                        returnToCaller();
                    }
                    return null;
                });
    }

    private void returnToCaller() {

        if (btDevice == null) {
            Log.w(LOG_TAG, "returnToCaller: btDevice is null!");
            setResult(RESULT_CANCELED);
        } else {
            Intent resIntent = new Intent();
            resIntent.putExtra(PARAM_SELECTED_DEVICE, btDevice);
            setResult(RESULT_OK, resIntent);
        }
        finish();
    }


    /**
     * Handle the reconnection after a dropped BT connection.
     * Copied from the starter mbientlab app
     * @param board
     * @return
     */
    public static Task<Void> reconnect(final MetaWearBoard board) {
        return board.connectAsync()
                .continueWithTask(task -> {
                    if (task.isFaulted()) {
                        return reconnect(board);
                    } else if (task.isCancelled()) {
                        return task;
                    }
                    return Task.forResult(null);
                });
    }


    @Override
    public void onDestroy() {
        try {
            getApplicationContext().unbindService(this);
        } catch (Exception e) {
            Log.e(LOG_TAG, "onDestroy: ",e);
        } finally {
            super.onDestroy();
        }

    }
}
